/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.explosions;

import com.alexander.mutantmore.interfaces.IHasCustomExplosion;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final ExplosionDamageCalculator damageCalculator;
    private final RandomSource random = RandomSource.m_216327_();
    private final Level level;
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final float radius;
    public SoundEvent sound;
    public ParticleOptions particle;
    public ParticleOptions secondaryParticle;
    public float damage;
    public SoundSource soundSource;
    public boolean damageRelativeToDistance;
    public boolean friendlyFire;

    public CustomExplosion(Level level, Entity explodingEntity, DamageSource damageSource, ExplosionDamageCalculator damageCalculator, double x, double y, double z, float explosionSize, boolean createsFire, Explosion.BlockInteraction blockInteraction, SoundEvent explosionSound, SoundSource explosionSoundSource, ParticleOptions explosionParticle, ParticleOptions secondaryExplosionParticle, float entityDamage, boolean damageRelativeToDistance, boolean friendlyFire) {
        super(level, explodingEntity, damageSource, damageCalculator, x, y, z, explosionSize, createsFire, blockInteraction);
        this.sound = explosionSound;
        this.particle = explosionParticle;
        this.secondaryParticle = secondaryExplosionParticle;
        this.damage = entityDamage;
        this.soundSource = explosionSoundSource;
        this.level = level;
        this.fire = createsFire;
        this.blockInteraction = blockInteraction;
        this.radius = explosionSize;
        this.damageCalculator = damageCalculator == null ? this.makeDamageCalculator(explodingEntity) : damageCalculator;
        this.damageRelativeToDistance = damageRelativeToDistance;
        this.friendlyFire = friendlyFire;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity p_46063_) {
        return p_46063_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(p_46063_);
    }

    public boolean canHarm(Entity target) {
        if (this.getExploder() != null && this.getExploder() instanceof IHasCustomExplosion) {
            if (this.friendlyFire) {
                return true;
            }
            return ((IHasCustomExplosion)this.getExploder()).canHarmWithExplosion(target);
        }
        return true;
    }

    public void m_46075_(boolean p_46076_) {
        boolean flag;
        if (this.sound != null) {
            this.level.m_6263_((Player)null, this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, this.sound, this.soundSource, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        }
        boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.NONE;
        if (p_46076_ && !this.level.f_46443_) {
            if (this.particle == ParticleTypes.f_123813_ || this.particle == ParticleTypes.f_123812_ || this.secondaryParticle == ParticleTypes.f_123813_ || this.secondaryParticle == ParticleTypes.f_123812_) {
                if (!(this.radius < 2.0f) && flag) {
                    ((ServerLevel)this.level).m_8767_(this.secondaryParticle, this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, 1, 0.0, 1.0, 0.0, 0.0);
                } else {
                    ((ServerLevel)this.level).m_8767_(this.particle, this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, 1, 0.0, 1.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (!(this.radius < 2.0f) && flag) {
                        ((ServerLevel)this.level).m_8767_(this.secondaryParticle, this.getPosition().f_82479_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), this.getPosition().f_82480_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), this.getPosition().f_82481_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), 1, 0.0, 1.0, 0.0, 0.0);
                        continue;
                    }
                    ((ServerLevel)this.level).m_8767_(this.particle, this.getPosition().f_82479_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), this.getPosition().f_82480_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), this.getPosition().f_82481_ - (double)this.radius + (double)this.random.m_188503_((int)this.radius * 2), 1, 0.0, 1.0, 0.0, 0.0);
                }
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.m_46079_() instanceof Player;
            Util.m_214673_((ObjectArrayList)((ObjectArrayList)this.m_46081_()), (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.m_46081_()) {
                Level $$9;
                BlockState blockstate = this.level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && ($$9 = this.level) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)$$9;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder(serverlevel).m_230911_(this.level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockentity).m_78984_(LootContextParams.f_81455_, (Object)this.getExploder());
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY) {
                        lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_222967_(serverlevel, blockpos, ItemStack.f_41583_, flag1);
                    blockstate.m_60724_(lootcontext$builder).forEach(p_46074_ -> CustomExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.m_46081_()) {
                if (this.random.m_188503_(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    public static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int i = p_46068_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_46068_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_46069_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_46069_, (int)16);
            p_46068_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }

    public void m_46061_() {
        this.level.m_220400_(this.getExploder(), GameEvent.f_157812_, new Vec3(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_));
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.getPosition().f_82479_;
                    double d6 = this.getPosition().f_82480_;
                    double d8 = this.getPosition().f_82481_;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.getPosition().f_82479_ - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.getPosition().f_82479_ + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.getPosition().f_82480_ - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.getPosition().f_82480_ + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.getPosition().f_82481_ - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.getPosition().f_82481_ + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.getExploder(), new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.getPosition().f_82479_) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.getPosition().f_82480_) * d7 + (d9 = entity.m_20189_() - this.getPosition().f_82481_) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = CustomExplosion.m_46064_((Vec3)vec3, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            if (this.damage > 0.0f && this.canHarm(entity)) {
                entity.m_6469_(this.m_46077_(), this.damage);
            }
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }
}

